% main9_case3.m 
% Fig. 9.9; Fig. 9.10
% --------------------------------
% cca.m             % subroutine
% ort_pk.m          %
% po-moesp.m        %
%-----------
clear
clf;
m=1;
p=1;
n=5;
a=0.9;
k = 10;
N = 4000;
M = N + 2*k -1;
maga_st = [];
f=[10^(-2):pi/512:pi];
t=0:0.01:2*pi;
w = linspace(0,pi,1000);
maga_st = [];
%
SN=zeros(20,1);
randn('state',0)   %  the same random numbers are generated
nump = [0  0  0  0  0.0275  0.0551];
denp = [1 -2.3443 3.081 -2.5274 1.2415 -0.3686];
%nump = [0.0275,0.0551];
%denp = [1,-2.7940,4.5645,-4.5518,2.7797,-0.9866];
[AP,BP,CP,DP]=tf2ss(nump,denp);
%
figure(1)                      %% poles of plant
a=plot(real(eig(AP)),imag(eig(AP)),'r+');
set(a,'markersize',36)
hold on 
plot(sin(t),cos(t),'-')
axis('square')
axis([-1 1 -1 1])
grid
%%
%%
numh = [1,-0.20,-0.48];
denh = [1,0.4,0.8];
%denh = [1 0.4 0.4];
[Ah,Bh,Ch,Dh]=tf2ss(numh,denh);
%
for jj = 1:30,
fprintf('jj = %d\n',jj);
%----------------------------------------------------
% disturbance  v1
%---------
v1= randn(1,M);
% input signal
u = randn(1,M);      % white noise
v2 = randn(1,M);
g0=0.3;
up=u+g0*v2;
v1=0.1*v1;  % variance of v1 = 0.01
Varv(jj)=var(v1);
%---------
x_p=zeros(n,1);  % initial state
for i=1:M
  s(i) = CP*x_p+DP*up(i);
  y(i) = s(i)+v1(i);
  x_p  = AP*x_p+BP*up(i);
end
Vars(jj)=var(s);
%----------------------------------------------------
% system identification
%---------------
% generation of block matrices 
%---------------
Up = []; Uf = [];
Yp = []; Yf = [];
for j = 1:k
 Up = [Up;u(:,j:N+j-1)];
 Yp = [Yp;y(:,j:N+j-1)];
end
for j = k+1:2*k,
 Uf = [Uf;u(:,j:N+j-1)];
 Yf = [Yf;y(:,j:N+j-1)];
end
%---------------
% data matrices 
%---------------
Ua = [Uf;Up];
Ya = [Yp;Yf];
%[Aa,Ba,Ca,Da,K]=cca(y,u,n,k);   % CCA Katayama-Picci
[Aa,Ba,Ca,Da] = ort_pk(Ua,Ya,m,p,n,k);  % ORT method
%[Aa,Ba,Ca,Da] = po_moesp(Ua,Ya,m,p,n,k); % PO-MOESP method

figure(1)
plot(real(eig(Aa)), imag(eig(Aa)),'*')
hold on 

[numa,dena] = ss2tf(Aa,Ba,Ca,Da,1);      % transfer function
% results
%--------
maga = dbode(Aa,Ba,Ca,Da,1,1,w);     % discrete-time Bode plot
maga_st = [maga_st,maga];
mag_nm = dbode(nump,denp,1,w);       % discrete-time Bode plot

figure(2);
clf;
plot(w,20*log10(mag_nm),'-',w,20*log10(maga_st),':');
axis([0,3.14159,-60,10]);
set(gca,'FontName','times','FontSize',20);
end; % of j_
grid
varv=mean(Varv)
vars=mean(Vars)
ratio=mean(Vars)/mean(Varv)
N
k
%----------------------------------------------------
epsform(1,'Real Part','Imaginary Part',[15 14],20,16,[],'',[])
epsform(2,'Frequency [rad/sec]','Gain [dB]',[16 12],20,16,[],'',[])

%
%
