function [A,B,C,D] = ort_pk(U,Y,m,p,n,k);
% function [A,B,C,D] = ort_pk(U,Y,m,p,n,k);
% ort_pk.m
% ORT % Orthogonal Decomposition
% by Picci and Katayama
% Nov 7, 2003
km=size(U,1)/2;
kp=size(Y,1)/2;

% LQ decomposition
L = triu(qr([U;Y]'))';
L11 = L(1:km,1:km);
L41 = L(2*km+kp+1:2*km+2*kp,1:km);
L42 = L(2*km+kp+1:2*km+2*kp,km+1:2*km);
L43 = L(2*km+kp+1:2*km+2*kp,2*km+1:2*km+kp);
[UU,SS,VV] = svd(L42);
%------------------------------------
U1 = UU(:,1:n);
Ok = U1*sqrtm(SS(1:n,1:n));
C = Ok(1:p,1:n);
A = pinv(Ok(1:p*(k-1),1:n))*Ok(p+1:k*p,1:n);

%------------------------------------
% calculation of B and D

U2 = UU(:,n+1:size(UU',1));
Xi = U2'*L41/L11;

XX = [];
RR = [];

for j = 1:k 
 XX = [XX;Xi(:,m*(j-1)+1:m*j)];

 Okj = Ok(1:p*(k-j),:);
 Rj = [zeros(p*(j-1),p),zeros(p*(j-1),n);
       eye(p), zeros(p,n);
       zeros(p*(k-j),p),Okj];
 RR = [RR;U2'*Rj];
end;
DB = pinv(RR)*XX;
D = DB(1:p,:);
B = DB(p+1:size(DB,1),:);
%
disp('ORT method')






