import matplotlib as mpl
from mpl_toolkits.mplot3d import Axes3D
import matplotlib.pyplot as plt
import numpy as np

def runge(dt,vinit,xinit,beta,wp,Fp,w,tstart=0.,tend=100.):
	t = np.arange(tstart,tend+dt,dt)
	V = np.copy(t)
	X = np.copy(t)
	V[0] = vinit
	X[0] = xinit
	for i in range(0,t.shape[0]-1,1):
		h1 = dt*g(t[i]       ,V[i]       ,X[i]       ,beta,wp,Fp,w)
		k1 = dt*h(t[i]       ,V[i]       ,X[i]       ,beta,wp,Fp,w)
		h2 = dt*g(t[i]+0.5*dt,V[i]+0.5*h1,X[i]+0.5*k1,beta,wp,Fp,w)
		k2 = dt*h(t[i]+0.5*dt,V[i]+0.5*h1,X[i]+0.5*k1,beta,wp,Fp,w)
		h3 = dt*g(t[i]+0.5*dt,V[i]+0.5*h2,X[i]+0.5*k2,beta,wp,Fp,w)
		k3 = dt*h(t[i]+0.5*dt,V[i]+0.5*h2,X[i]+0.5*k2,beta,wp,Fp,w)
		h4 = dt*g(t[i]+dt    ,V[i]+h3    ,X[i]+k3    ,beta,wp,Fp,w)
		k4 = dt*h(t[i]+dt    ,V[i]+h3    ,X[i]+k3    ,beta,wp,Fp,w)
		V[i+1] = V[i]+(h1+2*h2+2*h3+h4)/6.
		X[i+1] = X[i]+(k1+2*k2+2*k3+k4)/6.
	return t,X,V

def g(t,V,X,beta,wp,Fp,w):
	return -1.*(wp*wp)*X-beta*wp*wp*X**3.+Fp*np.sin(w*t)

def h(t,V,X,beta,wp,Fp,w):
	return V	

#### To analyze each part, comment out the other parts by adding "#" before the lines.

#Initialization

dt = 0.001
xinit = 0.
vinit = 0.
wp = 1.*np.pi
Fp = 100.
w = 2.*np.pi
beta = 100.

val = runge(dt,vinit,xinit,beta,wp,Fp,w,tstart=0.,tend=20.)
val1 = runge(dt,vinit,0.00001,beta,wp,Fp,w,tstart=0.,tend=20.)

fig = plt.figure(figsize=(18,4))
plt.plot(val[0],val[1],label='0.0')
plt.plot(val1[0],val1[1],label='0.01')
plt.xlim([0,20])
plt.xlabel('Time (s)')
plt.ylabel('Displacement (m)')
plt.legend(bbox_to_anchor=(0., 1.02, 1., .102), loc=3,
       ncol=3, mode="expand", borderaxespad=0.)
plt.show()
