import matplotlib as mpl
from mpl_toolkits.mplot3d import Axes3D
import matplotlib.pyplot as plt
import numpy as np

def runge(dt,vinit,xinit,beta,wp,Fp,w,tstart=0.,tend=100.):
	t = np.arange(tstart,tend+dt,dt)
	V = np.copy(t)
	X = np.copy(t)
	V[0] = vinit
	X[0] = xinit
	for i in range(0,t.shape[0]-1,1):
		h1 = dt*g(t[i]       ,V[i]       ,X[i]       ,beta,wp,Fp,w)
		k1 = dt*h(t[i]       ,V[i]       ,X[i]       ,beta,wp,Fp,w)
		h2 = dt*g(t[i]+0.5*dt,V[i]+0.5*h1,X[i]+0.5*k1,beta,wp,Fp,w)
		k2 = dt*h(t[i]+0.5*dt,V[i]+0.5*h1,X[i]+0.5*k1,beta,wp,Fp,w)
		h3 = dt*g(t[i]+0.5*dt,V[i]+0.5*h2,X[i]+0.5*k2,beta,wp,Fp,w)
		k3 = dt*h(t[i]+0.5*dt,V[i]+0.5*h2,X[i]+0.5*k2,beta,wp,Fp,w)
		h4 = dt*g(t[i]+dt    ,V[i]+h3    ,X[i]+k3    ,beta,wp,Fp,w)
		k4 = dt*h(t[i]+dt    ,V[i]+h3    ,X[i]+k3    ,beta,wp,Fp,w)
		V[i+1] = V[i]+(h1+2*h2+2*h3+h4)/6.
		X[i+1] = X[i]+(k1+2*k2+2*k3+k4)/6.
	return t,X,V

def g(t,V,X,beta,wp,Fp,w):
	return -1.*(wp*wp)*X-beta*wp*wp*X**3.+Fp*np.sin(w*t)

def h(t,V,X,beta,wp,Fp,w):
	return V	

#### To analyze each part, comment out the other parts by adding "#" before the lines.

#Initialization

dt = 0.001
xinit = 0.
vinit = 0.
wp = 1.*np.pi
Fp = 100.
w = 2.*np.pi
beta = 100.

val = runge(dt,vinit,xinit,beta,wp,Fp,w,tstart=0.,tend=10000.)

for f in range(0,1000):
	fig = plt.figure(f)
	plt.scatter(val[1][range(f,val[1].shape[0],1000)],\
                    val[2][range(f,val[1].shape[0],1000)],\
                    c=val[0][range(f,val[1].shape[0],1000)],\
                    vmin=0.,vmax=10000.,s=2.)
	plt.xlim([-1.,1.])
	plt.ylim([-20.,20.])
	plt.xlabel('Displacement m')
	plt.ylabel('Velocity m/s')
	plt.colorbar()
	plt.savefig('./result_%05d.png'%(f),bbox_inches='tight')
	#This will create multiple png files with each file representing a Poincare section.
	plt.close(fig)
