#Importing modules
import numpy as np
import matplotlib.pyplot as plt
import matplotlib as mpl
from mpl_toolkits.mplot3d import Axes3D

#Definition of constant variables
sigma = 10.
r = 28.
b = 8./3.

#Runge-Kutta function definition.
def rk(delta,t,xinit,yinit,zinit):
	x = np.copy(t)
	y = np.copy(t)
	z = np.copy(t)
	x[0] = xinit
	y[0] = yinit
	z[0] = zinit
	for i in range(0,t.shape[0]-1):
		h1 = delta*dxdt(x[i],y[i])
		k1 = delta*dydt(x[i],y[i],z[i])
		j1 = delta*dzdt(x[i],y[i],z[i])
		h2 = delta*dxdt(x[i]+h1/2.,y[i]+k1/2.)
		k2 = delta*dydt(x[i]+h1/2.,y[i]+k1/2.,z[i]+j1/2.)
		j2 = delta*dzdt(x[i]+h1/2.,y[i]+k1/2.,z[i]+j1/2.)
		h3 = delta*dxdt(x[i]+h2/2.,y[i]+k2/2.)
		k3 = delta*dydt(x[i]+h2/2.,y[i]+k2/2.,z[i]+j2/2.)
		j3 = delta*dzdt(x[i]+h2/2.,y[i]+k2/2.,z[i]+j2/2.)
		h4 = delta*dxdt(x[i]+h3,y[i]+k3)
		k4 = delta*dydt(x[i]+h3,y[i]+k3,z[i]+j3)
		j4 = delta*dzdt(x[i]+h3,y[i]+k3,z[i]+j3)
		x[i+1] = x[i] + (h1+2.*h2+2.*h3+h4)/6.
		y[i+1] = y[i] + (k1+2.*k2+2.*k3+k4)/6.
		z[i+1] = z[i] + (j1+2.*j2+2.*j3+j4)/6.
	return x,y,z

#Defining the function for the gradient.
def dxdt(x,y):
	return sigma*(y-x)
def dydt(x,y,z):
	return x*(r-z)-y
def dzdt(x,y,z):
	return x*y-b*z

delta = 0.01
xinit = 1.
yinit = 1.
zinit = 1.
t = np.arange(0,100.+delta,delta)
x1,y,z = rk(delta,t,xinit,yinit,zinit)
fig = plt.figure(1)
plt.plot(t,x1,label='x')
plt.plot(t,y,label='y')
plt.plot(t,z,label='z')
plt.legend(loc=0)
plt.show()

fig = plt.figure(2)
ax = fig.gca(projection='3d')
ax.plot(x1, y, z,label='Lorenz Attractor 1')
x2,y,z = rk(delta,t,xinit+0.5,yinit+0.5,zinit+0.5)
ax.plot(x2, y, z,label='Lorenz Attractor 2')
x3,y,z = rk(delta,t,xinit+10.,yinit+100.,zinit+100.)
ax.plot(x3, y, z,label='Lorenz Attractor 3')
ax.legend()
plt.show()
