import numpy as np
import matplotlib.pyplot as plt

def rk(t,dt,xinit,yinit,zinit):
        X = np.copy(t);Y = np.copy(t);Z = np.copy(t)
        X[:] = 0.; Y[:] = 0.; Z[:] = 0.
        X[0] = xinit; Y[0] = yinit; Z[0] = zinit
        for i in range(0,t.shape[0]-1):
                h1 = dt*dXdt(X[i],Y[i],Z[i])
                j1 = dt*dYdt(X[i],Y[i],Z[i])
                k1 = dt*dZdt(X[i],Y[i],Z[i])
                h2 = dt*dXdt(X[i]+0.5*h1,Y[i]+0.5*j1,Z[i]+0.5*k1)
                j2 = dt*dYdt(X[i]+0.5*h1,Y[i]+0.5*j1,Z[i]+0.5*k1)
                k2 = dt*dZdt(X[i]+0.5*h1,Y[i]+0.5*j1,Z[i]+0.5*k1)
                h3 = dt*dXdt(X[i]+0.5*h2,Y[i]+0.5*j2,Z[i]+0.5*k2)
                j3 = dt*dYdt(X[i]+0.5*h2,Y[i]+0.5*j2,Z[i]+0.5*k2)
                k3 = dt*dZdt(X[i]+0.5*h2,Y[i]+0.5*j2,Z[i]+0.5*k2)
                h4 = dt*dXdt(X[i]+h3,Y[i]+j3,Z[i]+k3)
                j4 = dt*dYdt(X[i]+h3,Y[i]+j3,Z[i]+k3)
                k4 = dt*dZdt(X[i]+h3,Y[i]+j3,Z[i]+k3)
                X[i+1] = X[i]+(h1+2.*h2+2.*h3+h4)/6.
                Y[i+1] = Y[i]+(j1+2.*j2+2.*j3+j4)/6.
                Z[i+1] = Z[i]+(k1+2.*k2+2.*k3+k4)/6.
        return X,Y,Z

def dXdt(X,Y,Z):
        return -sigma*(X-Y)

def dYdt(X,Y,Z):
        return -X*Z+gamma*X-Y

def dZdt(X,Y,Z):
        return X*Y-b*Z

global sigma,gamma,b
sigma = 10.
gamma = 28.
b = 8./3.

dt = 0.01
t = np.arange(0.,30.+dt,dt)
X1,Y1,Z1 = rk(t,dt,1.,2.,10.)
X2,Y2,Z2 = rk(t,dt,1.1,2.,10.)

plt.plot(t,X1,color='k',linestyle='-',label=r'case 1 $X$')
plt.plot(t,Z1,color='k',linestyle='-',label=r'case 1 $Z$')
plt.plot(t,X2,color='red',linestyle='-',label=r'case 2 $X$')
plt.plot(t,Z2,color='red',linestyle='-',label=r'case 2 $Z$')

plt.legend(loc='upper center',bbox_to_anchor=(0.5,1.1),ncol=4,fancybox=True,shadow=True)
plt.xlabel(r'$t$')
plt.ylabel(r'$X,Z$')
plt.show()
