import numpy as np
import matplotlib.pyplot as plt

def rk(t,dt,xinit,yinit,zinit):
	X = np.copy(t);Y = np.copy(t);Z = np.copy(t)
	X[:] = 0.; Y[:] = 0.; Z[:] = 0.
	X[0] = xinit; Y[0] = yinit; Z[0] = zinit
	for i in range(0,t.shape[0]-1):
		h1 = dt*dXdt(X[i],Y[i],Z[i])
		j1 = dt*dYdt(X[i],Y[i],Z[i])
		k1 = dt*dZdt(X[i],Y[i],Z[i])
		h2 = dt*dXdt(X[i]+0.5*h1,Y[i]+0.5*j1,Z[i]+0.5*k1)
		j2 = dt*dYdt(X[i]+0.5*h1,Y[i]+0.5*j1,Z[i]+0.5*k1)
		k2 = dt*dZdt(X[i]+0.5*h1,Y[i]+0.5*j1,Z[i]+0.5*k1)
		h3 = dt*dXdt(X[i]+0.5*h2,Y[i]+0.5*j2,Z[i]+0.5*k2)
		j3 = dt*dYdt(X[i]+0.5*h2,Y[i]+0.5*j2,Z[i]+0.5*k2)
		k3 = dt*dZdt(X[i]+0.5*h2,Y[i]+0.5*j2,Z[i]+0.5*k2)
		h4 = dt*dXdt(X[i]+h3,Y[i]+j3,Z[i]+k3)
		j4 = dt*dYdt(X[i]+h3,Y[i]+j3,Z[i]+k3)
		k4 = dt*dZdt(X[i]+h3,Y[i]+j3,Z[i]+k3)
		X[i+1] = X[i]+(h1+2.*h2+2.*h3+h4)/6.
		Y[i+1] = Y[i]+(j1+2.*j2+2.*j3+j4)/6.
		Z[i+1] = Z[i]+(k1+2.*k2+2.*k3+k4)/6.
	return X,Y,Z

def dXdt(X,Y,Z):
	return -Y-Z

def dYdt(X,Y,Z):
	return X+a*Y

def dZdt(X,Y,Z):
	return b+Z*(X-c)

'''
To omit the necessity of passing a and b as arguments, 
they can be set as global variables recognized throughout.
'''
global a,b,c
a = 0.1
b = 0.1
dt = 0.01
t = np.arange(0.,200.+dt,dt)

c=4.
X1,Y1,Z1 = rk(t,dt,1.,1.,1.)
c=12.
X2,Y2,Z2 = rk(t,dt,1.,1.,1.)
c=8.
X3,Y3,Z3 = rk(t,dt,1.,1.,1.)

plt.plot(X1,Y1,color='k',linestyle='-',label=r'case 1')
plt.plot(X2,Y2,color='red',linestyle='-',label=r'case 2')
plt.plot(X3,Y3,color=(.35,.35,.35),linestyle='-',label=r'case 3')
plt.xlabel(r'$X$')
plt.ylabel(r'$Y$')
plt.legend()
plt.show()
