import matplotlib.pyplot as plt
import numpy as np
plt.style.use('grayscale')

#parameters
a3=0.05
a4=0.00005

#dependent & independent variables
t = np.arange(0,120,1)
#temporarily construct an array of size similar to t.
N=np.zeros(t.shape,dtype=np.float32)

#boundary condition
Ninit=100

C=(a3-a4*Ninit)/Ninit
N=a3/(a4+C*np.exp(-a3*t))

Ninit=100
C=(a3-a4*Ninit)/Ninit
N=a3/(a4+C*np.exp(-a3*t))
plt.plot(t,N,label='100')
plt.xlabel("Days")
plt.ylabel("Population")
plt.title('Time series')
Ninit=2000
C=(a3-a4*Ninit)/Ninit
N=a3/(a4+C*np.exp(-a3*t))
plt.plot(t,N,label='2000') # Add a plot for the second case with Ninit=2000
plt.legend(loc=4)
plt.show()
