import matplotlib.pyplot as plt
import numpy as np

def nat(t,Xinit,cp,wp):
	X = Xinit*np.cos(wp*t)
	V = -wp*Xinit*np.sin(wp*t)
	return X,V

def under_dam(t,Xinit,cp,wp):
	p = -cp/2.
	q = np.sqrt(4*wp*wp-cp*cp)/2.
	X = Xinit*np.exp(p*t)*(np.cos(q*t)-(p/q)*np.sin(q*t))
	V = -Xinit*np.exp(p*t)*(q+((p*p)/q))*np.sin(q*t)
	return X,V

def crit_dam(t,Xinit,cp,wp):
	a = -cp/2.
	X = Xinit*(1-a*t)*np.exp(a*t)
	V = -Xinit*np.power(a,2)*t*np.exp(a*t)
	return X,V

def over_dam(t,Xinit,cp,wp):
	a = (-cp+np.sqrt(cp*cp-4*wp*wp))/2.
	b = (-cp-np.sqrt(cp*cp-4*wp*wp))/2.
	X = Xinit*(-b*np.exp(a*t)+a*np.exp(b*t))/(a-b)
	V = a*b*Xinit*(np.exp(b*t)-np.exp(a*t))/(a-b)
	return X,V

#Setting up the time coordinates
t = np.arange(0,15.1,0.1)

#Initial conditions
Xinit = 1.

###Case 1
#Mass Set-up
m = 1.0
k = 1.0
c = 0.0
cp = c/m
wp = np.sqrt(k/m) #np.sqrt is a square root function

if cp==0.:
	X,V = nat(t,Xinit,cp,wp)
elif cp<2*wp:
	X,V = under_dam(t,Xinit,cp,wp)
elif cp==2*wp:
	X,V = crit_dam(t,Xinit,cp,wp)
else:
	X,V = over_dam(t,Xinit,cp,wp)

X1 = X
V1 = V

###Case 2
#Mass Set-up
m = 1.0
k = 1.0
c = 1.0
cp = c/m
wp = np.sqrt(k/m)

if cp==0.:
	X,V = nat(t,Xinit,cp,wp)
elif cp<2*wp:
	X,V = under_dam(t,Xinit,cp,wp)
elif cp==2*wp:
	X,V = crit_dam(t,Xinit,cp,wp)
else:
	X,V = over_dam(t,Xinit,cp,wp)

X2 = X
V2 = V

###Case 3
#Mass Set-up
m = 1.0
k = 1.0
c = 2.0
cp = c/m
wp = np.sqrt(k/m)

if cp==0.:
	X,V = nat(t,Xinit,cp,wp)
elif cp<2*wp:
	X,V = under_dam(t,Xinit,cp,wp)
elif cp==2*wp:
	X,V = crit_dam(t,Xinit,cp,wp)
else:
	X,V = over_dam(t,Xinit,cp,wp)

X3 = X
V3 = V

###Case 4
#Mass Set-up
m = 1.0
k = 1.0
c = 3.0
cp = c/m
wp = np.sqrt(k/m)

if cp==0.:
	X,V = nat(t,Xinit,cp,wp)
elif cp<2*wp:
	X,V = under_dam(t,Xinit,cp,wp)
elif cp==2*wp:
	X,V = crit_dam(t,Xinit,cp,wp)
else:
	X,V = over_dam(t,Xinit,cp,wp)

X4 = X
V4 = V

f,(ax1,ax2) = plt.subplots(1,2,figsize=(11,5))

ax1.plot(t,X1,'r',label='Case 1')
ax1.plot(t,X2,'b',label='Case 2')
ax1.plot(t,X3,'g',label='Case 3')
ax1.plot(t,X4,'k',label='Case 4')
ax1.legend(loc=4) # To plot the label at quadrant 4
ax1.set_title('Time Series Plot')
ax1.set_xlabel('Time (s)')
ax1.set_ylabel('Displacement (m)')
ax1.grid(True) #Include grid lines

ax2.plot(V1,X1,'r',label='Case 1')
ax2.plot(V2,X2,'b',label='Case 2')
ax2.plot(V3,X3,'g',label='Case 3')
ax2.plot(V4,X4,'k',label='Case 4')
ax2.legend(loc=4)
ax2.set_title('Phase Diagram')
ax2.set_xlabel('Velocity (m/s)')
ax2.grid(True)

plt.show()
