import numpy as np
import matplotlib.pyplot as plt

wp = 1. #natural angular frequency
w = np.linspace(0.,2.,100)
lstyle=['solid','dotted','dashed',(0, (5,1)),'dashdot']
lstyle_counter=0
for cp in [0.25,0.5,1.,2.,3.]:
	AoEp = 1/np.sqrt((wp**2.-w**2.)**2.+cp**2.*w**2.)
	plt.plot(w,AoEp,color='k',
		linestyle=lstyle[lstyle_counter],
		label='$c_p$=%4.2f'%(cp))
	lstyle_counter+=1
plt.xlim([0.,2.])
plt.ylabel(r'$A/E_p$')
plt.xlabel(r'$\omega$')
plt.legend()
plt.show()
