import matplotlib.pyplot as plt
import numpy as np

#Constant parameters for all set-ups
m = 1.0
k = np.pi**2
Fo = 80.

#time coordinates
t=np.arange(0,50.01,0.01)

#Case 3
#Parameters
wp = np.sqrt(k/m)
w = 2.*np.pi
Fp = Fo/m

X = Fp*(-(w/wp)*np.sin(wp*t)+np.sin(w*t))/(wp*wp-w*w)
V = Fp*w*(-np.cos(wp*t)+np.cos(w*t))/(wp*wp-w*w)

plt.plot(V,X)
plt.xlabel('Velocity (m/s)')
plt.ylabel('Displacement (m)')
plt.title(r'$\omega=2\pi$ and $\omega_p=\pi$')
plt.grid(True)
plt.show()
