import matplotlib.pyplot as plt
import numpy as np

#Constant parameters for all set-ups
m = 1.0
k = np.pi**2
Fo = 80.

#time coordinates
t=np.arange(0,50.01,0.01)

#Case 6
wp = np.sqrt(k/m)
w = np.pi
Fp = Fo/m

X = Fp*(np.sin(wp*t)-t*wp*np.cos(wp*t))/2/wp/wp
V = Fp*(t*np.sin(wp*t))/2.

plt.plot(V,X)
plt.xlabel('Velocity (m/s)')
plt.ylabel('Displacement (m)')
plt.title(r'$\omega=\pi$ and $\omega_p=\pi$')
plt.grid(True)
plt.show()
