import numpy as np
import matplotlib.pyplot as plt

def exact(t,No):
	a3 = 0.05
	a4 = 0.00005
	c = (a3-a4*No)/No
	N = a3/(a4+c*np.exp(-a3*t))
	return N
def euler(t,No,delta):
	N = np.copy(t)
	N[0] = No
	for i in range(0,np.shape(t)[0]-1):
	     N[i+1] = N[i]+delta*dndt(N[i])
	return N
def heun(t,No,delta):
	N = np.copy(t)
	N[0] = No
	for i in range(0,np.shape(t)[0]-1):
		h1 = delta*dndt(N[i])
		h2 = delta*dndt(N[i]+h1)
		N[i+1] = N[i]+0.5*(h1+h2)
	return N
def rk(t,No,delta):
	N = np.copy(t)
	N[0] = No
	for i in range(0,np.shape(t)[0]-1):
		h1 = delta*dndt(N[i])
		h2 = delta*dndt(N[i]+h1/2.)
		h3 = delta*dndt(N[i]+h2/2.)
		h4 = delta*dndt(N[i]+h3)
		N[i+1] = N[i]+(h1+2.*h2+2.*h3+h4)/6.
	return N
def dndt(N):
	a3 = 0.05
	a4 = 0.00005
	return (a3-a4*N)*N

delta = 1.
t = np.arange(0.,120.+delta,delta)
No = 100
plt.plot(t,exact(t,No),'r',label='Exact')
plt.plot(t,euler(t,No,delta),'g',label='Euler')
plt.plot(t,heun(t,No,delta),'k',label='Heun')
plt.plot(t,rk(t,No,delta),'y',label='4th Runge-Kutta')
plt.legend(loc=0)
plt.xlabel('Days')
plt.ylabel('Organism Population')
plt.show()
