import numpy as np
import matplotlib.pyplot as plt

def exact(t):
	wp = np.pi
	w = 2.*np.pi
	Fp = 80.
	X = Fp*((-w*np.sin(wp*t)/wp)+np.sin(w*t))/(wp*wp-w*w)
	V = Fp*w*(-np.cos(wp*t)+np.cos(w*t))/(wp*wp-w*w)
	return X,V
def euler(t,delta):
	X = np.copy(t)
	V = np.copy(t)
	X[0] = 0.
	V[0] = 0.
	for i in range(0,np.shape(t)[0]-1):
		X[i+1] = X[i]+delta*dxdt(V[i])
		V[i+1] = V[i]+delta*dvdt(t[i],X[i])
	return X,V
def heun(t,delta):
	X = np.copy(t)
	V = np.copy(t)
	X[0] = 0.
	V[0] = 0.
	for i in range(0,np.shape(t)[0]-1):
		h1 = delta*dxdt(V[i])
		k1 = delta*dvdt(t[i],X[i])
		h2 = delta*dxdt(V[i]+k1)
		k2 = delta*dvdt(t[i]+delta,X[i]+h1)
		X[i+1] = X[i]+0.5*(h1+h2)
		V[i+1] = V[i]+0.5*(k1+k2)
	return X,V
def rk(t,delta):
	X = np.copy(t)
	V = np.copy(t)
	X[0] = 0.
	V[0] = 0.
	for i in range(0,np.shape(t)[0]-1):
		h1 = delta*dxdt(V[i])
		k1 = delta*dvdt(t[i],X[i])
		h2 = delta*dxdt(V[i]+k1/2.)
		k2 = delta*dvdt(t[i]+delta/2.,X[i]+h1/2.)
		h3 = delta*dxdt(V[i]+k2/2.)
		k3 = delta*dvdt(t[i]+delta/2.,X[i]+h2/2.)
		h4 = delta*dxdt(V[i]+k3/2.)
		k4 = delta*dvdt(t[i]+delta,X[i]+h3/2.)
		X[i+1] = X[i]+(h1+2.*h2+2.*h3+h4)/6.
		V[i+1] = V[i]+(k1+2.*k2+2.*k3+k4)/6.
	return X,V
def dxdt(V):
	return V
def dvdt(t,X):
	wp = np.pi
	w = 2.*np.pi
	Fp = 80.
	return -wp*wp*X+Fp*np.sin(w*t)

plt.figure(1, figsize=(12,6))
plt.subplot(1,2,1)
delta = 0.01
t=np.arange(0.,2.+delta,delta)
X,V=exact(t)
plt.plot(t,X,'r',label='exact')
plt.xlabel('days')
plt.ylabel('displacement')
plt.title('Euler')
for delta in [0.01,0.05,0.1]:
	t=np.arange(0.,2.+delta,delta)
	X,V=euler(t,delta)
	plt.plot(t,X,label=delta)
plt.legend(loc=0)
plt.subplot(1,2,2)
delta = 0.01
t=np.arange(0.,2.+delta,delta)
X,V=exact(t)
plt.plot(t,X,'r',label='exact')
plt.xlabel('days')
plt.ylabel('displacement')
plt.title('Runge-Kutta')
for delta in [0.01,0.05,0.1]:
	t=np.arange(0.,2.+delta,delta)
	X,V=rk(t,delta)
	plt.plot(t,X,label=delta)
	plt.subplot(1,2,2)
plt.legend(loc=0)
plt.show()
