@ Monte Carlo Simulation in Ch. 6.1 of Handbook of Econometrics	@
@ Author: Taisuke Otsu @
@ Program is written by GAUSS @

new;
format /m1/rd 8,3;

library optmum;

n=100;		@ sample size @
k=10;		@ number of moments @
rep=1000;	@ number of replication @

optset; __output=0; _opalgr = 2; _opmiter=200; @ options for optmum @

gmme=zeros(rep,1); ele=zeros(rep,1);
imc=1; do while imc<=rep;

	@ Data Generation @
	x=rndn(n,k);	@ draw N(0,1) @
	@x=sqrt(3)*rndn(n,k)./(sqrt(rndn(n,k)^2+rndn(n,k)^2+rndn(n,k)^2+rndn(n,k)^2+rndn(n,k)^2));@	@ draw standardized t(5) @
	
	gmme1=meanc(meanc(x^2));	@ first-step GMM @
	gdev=mom(gmme1)-(meanc(mom(gmme1)))';
	vgmm=inv((gdev'*gdev)/n);	@ Optimal weight @
	gmme[imc]=(ones(1,k)*vgmm*meanc(x^2))/(ones(1,k)*vgmm*ones(k,1));	@ two-step GMM @
	{ele[imc],elf,grad,retcode}=optmum(&elrsub,gmme1); @ EL estimation @

gmme[imc]~ele[imc];
imc=imc+1;
endo; 

"GMM Bias:" meanc(gmme-1);
"EL Bias:" meanc(ele-1);
"GMM Standard Error:" sqrt(meanc((gmme-meanc(gmme))^2));
"EL Standard Error:" sqrt(meanc((ele-meanc(ele))^2));
"GMM Root MSE:" sqrt(meanc((gmme-1)^2));
"EL Root MSE:" sqrt(meanc((ele-1)^2));

@ procedure: create moment restriction @
proc (1)=mom(param);
retp(x^2-param);
endp;

@ procedure: EL function @
proc (1)=elrsub(param);
local g,n,maxit,tol,lam,w,lik,direc,step,lam1,it,is;
	maxit=100;	@ maximum number of interations @
	tol=0.00001;	@ tolerance for convergence @
	g=mom(param);
	n=rows(g);
	lam=zeros(cols(g),1); w=ones(n,1); lik=0;
	for it (1,maxit,1);
		direc=sumc(g./w)/((g./w)'*(g./w));
		step=1; 
		for is (1,10,1);
			lam1=lam+direc*step;
			if (minc(1+g*lam1) .> (1/n)); if (-sumc(ln(1+g*lam1)) < lik); break; endif; endif;
			step=step/2;
		endfor;
		lam=lam1; w=1+g*lam; lik=-sumc(ln(w));
		if (maxc(abs(g'(1./w)))/n < tol); break; endif; 
		if it==maxit; "error: not converge"; endif;
	endfor;
retp(-lik);
endp;

end;
