' Maximum Likelihood Estimation: 
' HETEROSKEDASTIC T-ERROR MODEL
' mst_het1.prg
' start: 2005/9/8
' last-updated: 2005/10/3

smpl  eq4_smpl

series y= lnp
series x2=lnspace
series x3=lnage

'degree of freedom
scalar mt_nu=5

' number of variables
scalar mt_m=3

coef(32)  mt_b
coef(3)  mt_q
coef(2)  mt_mu
coef(1)  mt_sig

' set up likelihood function
logl  mt_log

mt_log.append  @logl  mt_logl1

mt_log.append  mt_u = y -mt_B(1) - mt_B(2)*x2 - mt_B(3)*x3 _
-mt_B(4)*FP1LDK-mt_B(5)*FP2LDK-mt_B(6)*FP4LDK-mt_B(7)*FP5LDK  _
-mt_B(8)*walk -mt_B(9)*north -mt_B(10)*knzwst  -mt_B(11)*eknzwst  _
-mt_B(12)*park -mt_B(13)*postoffice -mt_B(14)* hospital _
-mt_B(15)*market -mt_B(16)*school -mt_B(17)* library _
-mt_B(18)*Y2000Q2 -mt_B(19)*Y2000Q3 -mt_B(20)*Y2000Q4  _
-mt_B(21)*Y2001Q1 -mt_B(22)*Y2001Q2 -mt_B(23)*Y2001Q3 -mt_B(24)*Y2001Q4 _
-mt_B(25)*Y2002Q1 -mt_B(26)*Y2002Q2 -mt_B(27)*Y2002Q3 -mt_B(28)*Y2002Q4 _
-mt_B(29)*Y2003Q1 -mt_B(30)*Y2003Q2 -mt_B(31)*Y2003Q3 -mt_B(32)*Y2003Q4

mt_log.append  mt_f = mt_q(1)*(x2-mt_mu(1))^2 _
			+2*mt_q(2)*(x2-mt_mu(1))*(x3-mt_mu(2)) _
			+mt_q(3)*(x3-mt_mu(2))^2

mt_log.append  mt_detq = mt_q(1)*mt_q(3)-mt_q(2)^2

mt_log.append mt_logl1 = _
-(1/2)*mt_nu*log(3.14159) +@gammalog( (mt_nu+mt_m)/2 ) -@gammalog( mt_nu /2 ) _
-(1/2)*log(mt_sig(1)^2) +(1/2)*log(mt_detq) _
-(mt_m+mt_nu)/2* log(1+mt_f+mt_u^2/(mt_nu*mt_sig(1)^2))

' starting values
equation mteq1.ls  lnp c lnspace lnage  _
fp1ldk fp2ldk fp4ldk fp5ldk _
walk north knzwst  eknzwst park  postoffice  hospital  market  school  library _
y2000q2  y2000q3  y2000q4 _
y2001q1  y2001q2  y2001q3  y2001q4 _
y2002q1  y2002q2  y2002q3  y2002q4 _
y2003q1  y2003q2  y2003q3  y2003q4

mt_b= mteq1.@coefs
mt_sig = mteq1.@se

mt_mu(1) = @mean(x2)
mt_mu(2) = @mean(x3)

mt_q(1)=1
mt_q(2)=0.5
mt_q(3)=1

' estimate by MLE
mt_log.ml(showops, M=1000, c=0.001)

rename mt_logL1  eqmst_het1_logL
rename mt_log  eqmst_het1
show  eqmst_het1.output

'clean-up
delete  mteq1  _
mt_b  mt_g  mt_m  mt_nu   mt_u

