/* mct1a.e
Monte Carlo experiments of 

multiplicative heteroskedasticity

first: 05/6/27
last:  05/8/25
*/

new;
output file = C:\Kasumi\research\hetero\mctest\norm\mct1a.eo reset;

library pgraph;
graphset;


"*** 1. normal dist. N(0,1)***";
j=1;
for alp (0, 1.0, 0.1);
    "********************";
    print "alp2=alp3=" alp;
    alp2=alp;
    alp3=alp;
    call myhet(5000, j, alp2, alp3);
endfor;

"  ";
"*** 2. t(5) ***";
j=2;
for alp (0, 1.0, 0.1);
    "********************";
    print "alp2=alp3=" alp;
    alp2=alp;
    alp3=alp;
    call myhet(5000, j, alp2, alp3);
endfor;

"  ";
"*** 3.  U(-0.5, 0.5) ***";
j=3;
for alp (0, 1.0, 0.1);
    "********************";
    print "alp2=alp3=" alp;
    alp2=alp;
    alp3=alp;
    call myhet(5000, j, alp2, alp3);
endfor;

"  ";
"*** 4. log normal: Lambda(0,1)  ***";
j=4;
for alp (0, 1.0, 0.1);
    "********************";
    print "alp2=alp3=" alp;
    alp2=alp;
    alp3=alp;
    call myhet(5000, j, alp2, alp3);
endfor;

"  ";
"*** 5. chisq(2) ***";
j=5;
for alp (0, 1.0, 0.1);
    "********************";
    print "alp2=alp3=" alp;
    alp2=alp;
    alp3=alp;
    call myhet(5000, j, alp2, alp3);
endfor;

/**********************************************/
proc(0) = myHet(NOI, j, alp2, alp3);

local rfMEANm, L, nobs, iobs, nobsi, x2, x3, c, z2, z3, rf, 
H,chisq5, ep, u, beta1, beta2, beta3, alp1, y, CX, yhat, uhat, M0, sig2, r, w, Z, 
GDstat, df, pv, u2, CZ, f, BP, b, Rsq, Kstat1, Kstat2, Kstat3, 
ua, Gstat, GMSstat, iuhat, iuhatm, nuhat, n1, n2, mhat, GIstat, 
nuhat2, GI2stat, MZ, nuhat2M, Wstat1, Wstat2, rfMEAN;


/* results will be stored in the following matrix */
rfMEANm = zeros(22, 10);
/* counter */
L=1;

for nobs(20, 200, 20);

/*
    " ";
    print "number of observations = " nobs;
*/
    iobs = 50;
    nobsi = iobs+nobs;

    /* uniform dist. U(1,31) */
    x2 = 1+(31-1)*rndu(nobsi,1); /* Minotani(2003,p.202) */
    /* delete the initial observations */
    x2 = trimr(x2, iobs,0);
    c = ones(nobs, 1);
    z2 = ln(x2);

    /* log normal (3,1) */
    x3 =  exp(rndn(nobsi,1)+3);  
    /* delete the initial observations */
    x3 = trimr(x3, iobs,0);
    z3 = ln(x3);

    /* NOI=100; */
/*
    print "number of iterations = " NOI;
*/

    /* rejection frequencies is stored */
    rf =zeros(NOI,22);

    for H (1, NOI, 1);

            if j==1;
                 /* N(0,1) */
                ep = rndn(nobsi,1); 
            elseif j==2;
                /* t(5) */
                /* Minotani(2003),p. 242,260, alpha = 5/2, beta=2 */
                chisq5 = 2*rndgam(nobsi,1,(5/2)); 
                ep = rndn(nobsi,1) ./ sqrt(chisq5/5);  
            elseif j==3;
                /* U(-0.5, 0.5) */
                ep =  -0.5+(0.5-(-0.5))*rndu(nobsi,1); 
            elseif j==4;
                /* log normal: Lambda(0,1) */
                ep = exp(rndn(nobsi,1));  
            else;
                /* chisq(2) Minotani(2003),p.242*/
                /* Minotani(2003),p. 242,260, alpha = 2/2, beta=2 */
                ep = 2*rndgam(nobsi,1,(2/2));  
            endif;
        
        ep = trimr(ep, iobs, 0);

	    /* additive heteroskedasticity: Godfrey (1996) */
	    /* u= (1+alp2*x2+alp3*x3).* ep; */

	    /* multiplicative heteroskedasticity: Godfrey (1978) */
        alp1=0;
        u = sqrt(exp(alp1+alp2*z2 +alp3*z3)) .* ep;

        beta1 =1;
        beta2 =1;
        beta3 =1;
        y = beta1+ beta2*x2+beta3*x3+u;

        /* residuals */
        CX = c~x2~x3;
        uhat = (eye(nobs)-CX*inv(moment(CX,0))*CX')*y;

        /* fitted value */
        yhat = CX*inv(moment(CX,0))*CX'y;

        /* Godfrey (1978) test */
        M0 = eye(nobs)-(1/nobs)*ones(nobs,1)*ones(nobs,1)';
        sig2 = (uhat'uhat) ./ nobs;
        r = uhat^2 ./ sig2 -ones(nobs, 1);
        W = z2~z3;  /* p. 230 */
        Z = M0*W;

        GDstat = r'Z*inv(Z'Z)*Z'r/2;

        df=2;
        pv = cdfchic(GDstat, df);
        if pv <= 0.05;
            rf[H,1] = 1;
        endif;

        if pv <= 0.10;
            rf[H,2] = 1;
        endif;

        /* Breusch-Pagan (1979) test */
        u2 = uhat^2;
        CZ = c~z2~z3;
        f = u2 ./ sig2 - ones(nobs, 1);
        BP = f'CZ*inv(CZ'CZ)*CZ'f/2;

        df=2;
        pv = cdfchic(BP, df);
        if pv <= 0.05;
            rf[H,3] = 1;
        endif;

        if pv <= 0.10;
            rf[H,4] = 1;
        endif;

        /* Koenker (1981) test */
        u2 = uhat^2;

        M0 = eye(nobs)-(1/nobs)*ones(nobs,1)*ones(nobs,1)';
        CZ = c~z2~z3;
        b = inv(moment(CZ,0))*CZ'*u2;
        Rsq = (b'*CZ'*M0*CZ*b)/(u2'*M0*u2);

        Kstat1 = nobs*Rsq;

        df=2;
        pv = cdfchic(Kstat1, df);

        if pv <= 0.05;
            rf[H,5] = 1;
        endif;

        if pv <= 0.10;
            rf[H,6] = 1;
        endif;

        /* Koenker (1981) test z = yhat */
        u2 = uhat^2;

        M0 = eye(nobs)-(1/nobs)*ones(nobs,1)*ones(nobs,1)';
        CZ = c~yhat;
        b = inv(moment(CZ,0))*CZ'*u2;
        Rsq = (b'*CZ'*M0*CZ*b)/(u2'*M0*u2);

        Kstat2 = nobs*Rsq;

        df=1;
        pv = cdfchic(Kstat2, df);

        if pv <= 0.05;
            rf[H,7] = 1;
        endif;

        if pv <= 0.10;
            rf[H,8] = 1;
        endif;


        /* Koenker (1981) test z = yhat^2 */
        u2 = uhat^2;

        M0 = eye(nobs)-(1/nobs)*ones(nobs,1)*ones(nobs,1)';
        CZ = c~yhat^2;
        b = inv(moment(CZ,0))*CZ'*u2;
        Rsq = (b'*CZ'*M0*CZ*b)/(u2'*M0*u2);

        Kstat3 = nobs*Rsq;

        df=1;
        pv = cdfchic(Kstat3, df);

        if pv <= 0.05;
            rf[H,9] = 1;
        endif;

        if pv <= 0.10;
            rf[H,10] = 1;
        endif;

        /* Glejser (1969) test */
        ua = abs(uhat);

        M0 = eye(nobs)-(1/nobs)*ones(nobs,1)*ones(nobs,1)';
        CZ = c~z2~z3;
        b = inv(moment(CZ,0))*CZ'*ua;
        Rsq = (b'*CZ'*M0*CZ*b)/(ua'*M0*ua);

        Gstat = nobs*Rsq;

        df=2;
        pv= cdfchic(Gstat, df);

        if pv <= 0.05;
            rf[H,11] = 1;
        endif;

        if pv <= 0.10;
            rf[H,12] = 1;
        endif;

        /* Machado-Silva(2000) Glejser (1969) test */
       iuhat=zeros(nobs, 1);
       
        for i ( 1, nobs, 1);
	        if uhat[i,1] >= 0;
                iuhat[i, 1]=1;
            endif;
        endfor;

        /* print uhat~iuhat; */

	    iuhatm = meanc(iuhat);
        nuhat = zeros(nobs, 1);
        for i (1, nobs, 1);
    	   nuhat[i,1] = uhat[i,1]*(iuhat[i,1]-iuhatm);
        endfor;
        /* print uhat~iuhat~nuhat; */

        M0 = eye(nobs)-(1/nobs)*ones(nobs,1)*ones(nobs,1)';
        CZ = c~z2~z3;
        b = inv(moment(CZ,0))*CZ'*nuhat;
        Rsq = (b'*CZ'*M0*CZ*b)/(nuhat'*M0*nuhat);

        GMSstat = nobs*Rsq;

        df=2;
        pv= cdfchic(GMSstat, df);

        if pv <= 0.05;
            rf[H,13] = 1;
        endif;

        if pv <= 0.10;
            rf[H,14] = 1;
        endif;


        /* Im (2000) Glejser (1969) test */
       iuhat=zeros(nobs, 1);
       
        for i ( 1, nobs, 1);
	        if uhat[i,1] >= 0;
                iuhat[i, 1]=1;
            endif;
        endfor;

        /* print uhat~iuhat; */

	    n1 = sumc(iuhat); /* number of positive residuals */
        n2 = nobs - n1;  /* number of negative residuals */
        mhat = (n1-n2)/nobs;
        
        nuhat = ua - (uhat .* mhat) -meanc(ua);

       /*print ua~iuhat~nuhat; */

        M0 = eye(nobs)-(1/nobs)*ones(nobs,1)*ones(nobs,1)';
        CZ = c~z2~z3;
        b = inv(moment(CZ,0))*CZ'*nuhat;
        Rsq = (b'*CZ'*M0*CZ*b)/(nuhat'*M0*nuhat);

        GIstat = nobs*Rsq;

        df=2;
        pv= cdfchic(GIstat, df);

        if pv <= 0.05;
            rf[H,15] = 1;
        endif;

        if pv <= 0.10;
            rf[H,16] = 1;
        endif;


    	/* Im (2000) test2  */
   	    nuhat2 = nuhat^2;
    	MZ = M0*(z2~z3);

    	nuhat2M=zeros(nobs, nobs);
    	nuhat2M = diagrv(nuhat2M, nuhat2);

    	GI2stat = nuhat'MZ*inv(MZ'nuhat2M*MZ)*MZ'nuhat;    

    	df=2;
    	pv= cdfchic(GI2stat, df);

        if pv <= 0.05;
            rf[H,17] = 1;
        endif;

        if pv <= 0.10;
            rf[H,18] = 1;
        endif;


        /* White (1980) test */
        u2 = uhat^2;

        M0 = eye(nobs)-(1/nobs)*ones(nobs,1)*ones(nobs,1)';
        CZ = c~x2~x3~(x2^2)~(x3^2)~(x2 .* x3);
        b = inv(moment(CZ,0))*CZ'*u2;
        Rsq = (b'*CZ'*M0*CZ*b)/(u2'*M0*u2);

        Wstat1 = nobs*Rsq;

        df=5;
        pv = cdfchic(Wstat1, df);

        if pv <= 0.05;
            rf[H,19] = 1;
        endif;

        if pv <= 0.10;
            rf[H,20] = 1;
        endif;

        /* White (1980) test2 without cross terms */
        u2 = uhat^2;

        M0 = eye(nobs)-(1/nobs)*ones(nobs,1)*ones(nobs,1)';
        CZ = c~x2~x3~(x2^2)~(x3^2);
        b = inv(moment(CZ,0))*CZ'*u2;
        Rsq = (b'*CZ'*M0*CZ*b)/(u2'*M0*u2);

        Wstat2 = nobs*Rsq;

        df=4;
        pv = cdfchic(Wstat2, df);

        if pv <= 0.05;
            rf[H,21] = 1;
        endif;

        if pv <= 0.10;
            rf[H,22] = 1;
        endif;

    endfor;


    rfMEAN = MEANC(rf);

    /* rfMEANm = rfMEANm~rfMEAN;*/
     
    rfMEANm[1:22,L:L] = rfMEAN[1:22,1];
    L=L+1;

/*
    "  ";
    print "rejection rate of Godrey test (5%)=" rfMEAN[1,1];
    print "rejection rate of Godrey test(10%)=" rfMEAN[2,1];
    "  ";
    print "rejection rate of BP test (5%)=" rfMEAN[3,1];
    print "rejection rate of BP test(10%)=" rfMEAN[4,1];
    "  ";
    print "rejection rate of Koenker test (5%)=" rfMEAN[5,1];
    print "rejection rate of Koenker test(10%)=" rfMEAN[6,1];
    "  ";
    print "rejection rate of Koenker test(yhat)(5%)=" rfMEAN[7,1];
    print "rejection rate of Koenker test(yhat)(10%)=" rfMEAN[8,1];
    "  ";
    print "rejection rate of Koenker test(yhat2)(5%)=" rfMEAN[9,1];
    print "rejection rate of Koenker test(yhat2)(10%)=" rfMEAN[10,1];

    "  ";
    print "rejection rate of Glejser test (5%)=" rfMEAN[11,1];
    print "rejection rate of Glejser test(10%)=" rfMEAN[12,1];
    "  ";
    print "rejection rate of Machado-Silvia-Glejser test (5%)=" rfMEAN[13,1];
    print "rejection rate of Machado-Silvia-Glejser test(10%)=" rfMEAN[14,1];
    "  ";
    print "rejection rate of Im-Glejser test (5%)=" rfMEAN[15,1];
    print "rejection rate of IM-Glejser test(10%)=" rfMEAN[16,1];
    "  ";
    print "rejection rate of Im-Glejser test (5%)=" rfMEAN[17,1];
    print "rejection rate of IM-Glejser test(10%)=" rfMEAN[18,1];


    "  ";
    print "rejection rate of White test(5%)=" rfMEAN[19,1];
    print "rejection rate of White test(10%)=" rfMEAN[20,1];

    "  ";
    print "rejection rate of White test: no cross terms (5%)=" rfMEAN[21,1];
    print "rejection rate of White test: no cross terms(10%)=" rfMEAN[22,1];
*/

endfor;

print rfMEANm;

endp;


end;
