clear all

randn('state',123)                 %@񓯂p^[ŗ𔭐B

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% set up %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

howlong = 115;                     % Tvԁi115lj
howmany = 10000;                   % V~[V
n_var = 6;                         % ϐ̑
n_exo = 1;                         % OϐiZpVbNj̐
period = 32;                       % Otp̊
g0          = zeros(n_var,n_var);  % x(t+1)
g1          = zeros(n_var,n_var);  % x(t)
c           = zeros(n_var,1);      % constant
psi         = zeros(n_var,n_exo);  % shocks(t+1)
pi          = zeros(n_var,n_var);  % expectations(t+1)
SSigma      = zeros(n_exo,n_exo);  % VbN̕U
vec_moments = [];                  % Ɏg߂ɍsp
SHP         = [];                  % Ɏg߂ɍsp
SRHP        = [];                  % Ɏg߂ɍsp
CHP_y       = [];                  % Ɏg߂ɍsp

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% deep parameters %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

beta=1/1.01;   theta=0.36;    delta=0.025;
eta=1;         gamma=0.95;    A=2.5846; % A=cc^(-eta)*(1-theta)*y/n=2.5846
SSigma(1,1)=0.712^2;        


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Steady States (20.20) %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

k_n=(((1-beta*(1-delta))/(beta*theta)))^((1/(theta-1)));
cc=(((1-theta)/A)*((k_n))^theta)^(1/eta);
k=cc*(((k_n))^(theta-1)-delta)^(-1);
n=(((1-theta)/(A*cc^eta)))^((1/theta))*k;
y=k^theta*n^(1-theta);
x=y-cc;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% program for running gensys %%%%%%%%%%%%%%%%%%%%%%%%%%%
% note that K at time (t+1) are known at t+1. %%%%%%%%%%
% defining matrices %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% 1 (20.25)
g0(1,1)=-eta; g0(1,2)=1; g0(1,3)=-1;
% 2 (20.26)
g0(2,1)=-eta; g1(2,1)=-eta; g1(2,2)=-(1-beta*(1-delta)); g0(2,4)=-(1-beta*(1-delta)); pi(2,2)=1; 
% 3 (20.23)
g0(3,2)=-1; g0(3,3)=1-theta; g1(3,4)=-theta; g0(3,5)=1;
% 4 (20.24)
g0(4,1)=-cc/y; g0(4,2)=1; g0(4,4)=-k/y; g1(4,4)=-(1-delta)*k/y;
% 5 (20.27)
g0(5,5) = 1; g1(5,5) = gamma; psi(5,1) = 1;
% 6 (y=c+ȋΐ`)
g0(6,1)=cc; g0(6,2)=-y; g0(6,6)=x; 

[G1,C,impact,fmat,fwt,ywt,gev,eu]=gensys(g0,g1,c,psi,pi);

% F(20.34)Ƃ͕ϐ̕яقȂ邪ASełB
%     ł͕ϐ(c, y, n, k, z, x)'̏ŕłB



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Impulse Responses %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
shock = 1;                           % 1%̋ZpVbN
seri  = [];
added = zeros(n_var,1);              
seri  = [seri added];
added = C+G1*added+impact*shock;
seri  = [seri added];

for j= 2:period
   added = C+G1*added;
   seri = [seri added];
end
   chat = seri(1,2:period);
   yhat = seri(2,2:period);
   nhat = seri(3,2:period);
   khat = seri(4,2:period);
   zhat = seri(5,2:period);
   xhat = seri(6,2:period);
     
% Draw impulse responses
zero       = zeros(size([2:period]));
figure;

subplot(2,3,1);
plot([2:period],zhat,'-k');
title('Shock');
axis([2,period,-1,3])
line([2:period],zero,'linestyle','-','LineWidth',0.5)
grid on;

subplot(2,3,2);
plot([2:period],yhat,'-k');
title('Output');
axis([2,period,-1,3])
line([2:period],zero,'linestyle','-','LineWidth',0.5)
grid on;

subplot(2,3,3);
plot([2:period],chat,'-k');
title('Consumption');
axis([2,period,-1,3])
line([2:period],zero,'linestyle','-','LineWidth',0.5)
grid on;

subplot(2,3,4);
plot([2:period],nhat,'-k');
title('Labor');
axis([2,period,-1,3])
line([2:period],zero,'linestyle','-','LineWidth',0.5)
grid on;

subplot(2,3,5);
plot([2:period],khat,'-k');
title('Capital');
axis([2,period,-1,3])
line([2:period],zero,'linestyle','-','LineWidth',0.5)
grid on;

subplot(2,3,6);
plot([2:period],xhat,'-k');
title('Investment');
axis([2,period,-1,8])
line([2:period],zero,'linestyle','-','LineWidth',0.5)
grid on;



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Monte Carlo simulations %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Sigma       = chol(SSigma);

for simul = 1:howmany;
   [simul howmany]; 
   seri        = [];
   added = zeros (n_var,1);

   for pe = 1:howlong;
       added = C+G1*added+impact*Sigma*[randn(1,n_exo)]';
       seri = [seri added];
   end

   for i=1:n_var
		serihp(i,:) = seri(i,:)-(hpfilter(seri(i,:),1600))';
   end
   
   series = serihp([2,1,3,4,5,6],:)';                                           % y擪ɗ悤ɏԂ𒲐

   dum = tril(corrcoef(series),-1)+diag(sqrt(diag(cov(series))));
   vec_moments = [vec_moments vech(dum)];

   SHP =[SHP;std(series)];                                                      % volatility 
   SRHP=[SRHP;std(series)/std(series(:,1))];                                    % volaility w.r.t. home output
   VCOV=series'*series;                                                     
   CHP_y    = [CHP_y   ; VCOV(1,:)./sqrt(diag(VCOV)'*VCOV(1,1))];               % cross corr w/ output       

end

mean_moments_A  = vech_1((mean(vec_moments'))',n_var)                           % diagonal=SD, off-diagonal=correlation
mean_moments_B  = [mean(SHP)' mean(SRHP)' mean(CHP_y)']                         % SD, RSD, corr w/output

% mean_moments_Amean_moments_B{Iɂ͓Bϐ(y, c, n, k, z, x)'̏ŕłB
