function M = vech_l(x,n)

if size(x,1) ~= n*(n+1)/2 | size(x,2) ~= 1
	disp('ERROR in vech_1.m')
	return
else
	M = zeros(n,n);
	for i = 1:n
		junk = (i-1)*n - (i-1)*(i-2)/2;
		M(i:n,i) = x(junk+1:junk+n-i+1,:);		
	end
	M = M+M';
	for i = 1:n
		M(i,i) = M(i,i)/2;
	end
end
