*
* analysis of dropout.dta
*
clear
set more off
set scheme s1mono
log using dropout.log, replace

* data
use dropout, clear

* set survival data
stset dur, failure(evt)
graph set eps

* weibull model
streg sex grd prt lag, d(weibull) nohr
stcurv, hazard title( "Dropout data" ) xtitle( "time" ) ytitle( "h(t)")
graph export dropout.eps, as(eps) replace

* Cox model by Breslow's approximation
stcox sex grd prt lag, breslow nohr basesurv(bs)
stcurv, survival title( "Breslow" ) xtitle( "time" ) ytitle( "S(t)")
graph export breslow.eps, as(eps) replace


* Cox model by Efron's approximation
stcox sex grd prt lag, efron nohr basesurv(es)
stcurv, survival title( "Efron" ) xtitle( "time" ) ytitle( "S(t)" )
graph export efron.eps, as(eps) replace

log close

