*
* Analysis of kennan.dta
*
clear
set more off
set scheme s1mono
log using strike.log, replace

* data
use strike, clear

* set survival data
stset time, failure(status)

* Kaplan-Meier
sts graph, gwood title( "Strike data" ) xtitle( "time" ) ytitle( "S(t)" ) ylabel(,nogrid ) legend( off )
graph export fig-kennan.eps, as(eps) replace

* Nelson-Aalen
sts graph, na title( "" ) xtitle( "time" ) ytitle( "H(t)" ) ylabel(,nogrid )
graph export fig-kennan3.eps, as(eps) replace

sts generate km=s
sts generate na=na
replace na = exp(-na)
label var km "Kaplan-Meier"
label var na "Nelson-Aalen"
graph twoway line km na time, c(J J) sort xtitle( "time" ) ytitle( "S(t)" ) legend(position(2) ring(0) col(1) ) lpattern( solid longdash )
graph export fig-kennan2.eps, as(eps) replace

log close

