clear
capture log close
set more off 
cd "C:\Documents and Settings\Administrator\My Documents\applied_econometrics_handbook\data_v1.0" /*specify your working folder*/

/*************load annual bank data****************/ 
insheet using bank_hi_pcm.csv, comma name
tsset year

log using scp,replace
/*************16.7.1 SCP hypothesis****************/
summarize pcm hi sd_cost tot_interest tot_funding_rate wage
sutex pcm hi sd_cost tot_interest tot_funding_rate wage, minmax /* can download by typing "findit sutex" */

/*SCP hypothesis*/
graph twoway lfitci pcm hi || scatter pcm hi, mlabel(year) ||, ///
ytitle("Price Cost Margin") xtitle("Herfindahl Index") legend(order(2 1) ///
label(1 "95% confidence interval") label(2 "regression line") rows(3) position(5) ring(0)) saving(figure1,replace)

reg pcm hi /*regress pcm on herfindahl index*/
estat dwatson /*Darbin-Watson autocorrelation test*/
hettest /*Breusch-Pagan heteroschedasticity test*/

/*Demsetz's hypothesis*/
graph twoway lfitci hi sd_cost || scatter hi sd_cost, mlabel(year) ||, ///
ytitle("Herfindahl Index") xtitle("Cross-sectional Standard Deviation of Funding Costs") legend(order(2 1) ///
label(1 "95% confidence interval") label(2 "regression line") rows(3) position(7) ring(0)) saving(figure2,replace)

reg hi sd_cost
estat dwatson
hettest

log close
clear

/******load monthly data*******/
insheet using chapter_io_monthly.csv, comma name 
g ym=ym(year,month)
format ym %tm
tsset ym

log using bresnahan1982,replace
/******************** 16.7.2. Bresnahan(1982)/Lau(1982) by LIML **********************/
sum loan loan_rate iaia cp_rate cd_rate d_e
sutex, minmax

capture program drop bresnahan_liml

program define bresnahan_liml  /*specify the log likelihood function*/
	version 10.1
	args lnf theta1 theta2 theta3 beta1 lambda sigma1 sigma2 
	tempvar tmp1 tmp2 tmp3 s1 s2 
	quietly generate double `tmp1' = $ML_y1-`theta1'-(`theta2'-exp(`beta1'))*$ML_y2
	qui gen double `tmp2' = $ML_y2-`theta3'+exp(`lambda')*($ML_y1/(`theta2'-exp(`beta1')))
	qui gen double `s1' = `sigma1' 
	qui gen double `s2' = `sigma2'
	qui replace `lnf' = -.5*(ln(2*`s1'*_pi)+ln(2*`s2'*_pi)+(`tmp1'/`s1')^2+(`tmp2'/`s2')^2)
end

ml model lf bresnahan_liml (loan loan_rate = iaia cp_rate season2-season12)(cp_rate, noconst)(loan cd_rate d_e) ///
	(beta1:)(lambda:)(sigma1:)(sigma2:), vce(robust) /*specify the model*/
ml maximize /*max the log likelihood*/

log close

log using porter1983,replace
/**********************16.7.3. Porter(1983): EM algolism (LIML)*******************************/

qui capture program drop porter
program define porter
	version 10.1
	args lnf theta1 theta2 beta1 beta3 sigma1 sigma2  
	tempvar tmp1 tmp20 tmp21 tmp3 s1 s2 
	qui gen double `tmp1' = $ML_y1+exp(`beta1')-`theta1'
	qui gen double `tmp20' = $ML_y2-`theta2'
	qui gen double `tmp21' = $ML_y2-`theta2'-exp(`beta3')
	qui gen double `s1' = `sigma1'
	qui gen double `s2' = `sigma2'
	qui replace `lnf' = -ln(2*`s1'*`s2'*_pi)+ln((1-lambda)*exp(-.5*(`tmp1'/`s1')^2)*exp(-.5*(`tmp20'/`s2')^2)+ ///
		 lambda*exp(-.5*(`tmp1'/`s1')^2)*exp(-.5*(`tmp21'/`s2')^2))
	qui replace p_0= exp(-.5*(`tmp1'/`s1')^2)*exp(-.5*(`tmp20'/`s2')^2) 
	qui replace p_1= exp(-.5*(`tmp1'/`s1')^2)*exp(-.5*(`tmp21'/`s2')^2)
end

qui capture program drop EM
program define EM /*define the EM algorism*/
	version 10.1
	capture drop omega0 omega1 p_0 p_1 lambda
	g omega0 = runiform() /* give the initial value for omega0 */
	g omega1 = runiform() /*  give the initial value for omega1 */
	egen lambda=mean(omega0)
	g p_0=.
	g p_1=.
	scalar corr_omega=0
	qui matrix b0=(0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1,0,0,0,-5,2,2)
	qui while (corr_omega <= 0.999) { 
		replace omega0 = omega1
		drop lambda
		egen lambda = mean(omega0)
		/*Maximizaion stage*/
		ml model lf porter (ln_loan ln_rate = season2-season12 ln_iaia ln_cp_rate)(ln_loan ln_cd_rate d_e) ///
			(beta1:ln_rate, noconstant)(beta3:)(sigma1:)(sigma2:), init(b0, copy) vce(robust)
		ml maximize, nolog
		matrix b0=e(b)
		/*Expectation stage*/
		replace omega1=p_1*lambda/(p_0*(1-lambda)+p_1*lambda)
		corr omega1 omega0
		scalar corr_omega=r(rho)
	}

	ml model lf porter (ln_loan ln_rate = season2-season12 ln_iaia ln_cp_rate)(ln_loan ln_cd_rate d_e) /// 
		(beta1:ln_rate, noconstant)(beta3:)(sigma1:)(sigma2:), init(b0, copy) vce(robust)
	ml maximize, nolog
end

EM /*run the EM algorism*/

/*****plot collusion probability*****/
graph twoway line omega1 ym, saving(porter1983,replace) ytitle("Estimated probability of collusion") ///
	xtitle("Month") xlabel(416(20)578) 

log close
clear

log using ellison1994,replace

/**********************switch to quarterly data*********************/
insheet using chapter_io_quarterly.csv, name comma
g yq=yq(year,quarter)
format yq %tq


/*********************16.7.3. Ellison(1994): LIML**************************/
g collude =.
capture program drop ellison
program define ellison
	version 10.1
	args lnf theta1 theta2 theta3 beta1 beta3 sigma1 sigma2  
	tempvar tmp1 tmp20 tmp21 tmp3 s1 s2 
	qui gen double `tmp1' = $ML_y1+exp(`beta1')-`theta1'
	qui gen double `tmp20' = $ML_y2-`theta2'
	qui gen double `tmp21' = $ML_y2-`theta2'-exp(`beta3')
	qui gen double `tmp3' = exp(`theta3')/(1+exp(`theta3'))
	qui gen double `s1' = `sigma1'
	qui gen double `s2' = `sigma2'
	qui replace `lnf' = -ln(2*`s1'*`s2'*_pi)+ln((1-`tmp3') *exp(-1/2*(`tmp1'/`s1')^2)*exp(-1/2*(`tmp20'/`s2')^2)+ ///
	 `tmp3'*exp(-1/2*(`tmp1'/`s1')^2)*exp(-1/2*(`tmp21'/`s2')^2)) 
end

matrix b0=(0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,2,2)
ml model lf ellison (ln_loan ln_rate = ln_iaia ln_cp_rate season2 season3 season4) ///
	(ln_loan ln_cd_rate d_e)(theta3: di di_future) ///
	(beta1:ln_rate, noconstant)(beta3:)(sigma1:)(sigma2:),init(b0, copy) vce(robust)
ml maximize, dif nolog
replace collude=exp(_b[theta3:di]*di+_b[theta3:di_future]*di_future+_b[theta3:_cons]) ///
	/(1+exp(_b[theta3:di]*di+_b[theta3:di_future]*di_future+_b[theta3:_cons]))

/***plot collusion probability*****/
graph twoway line collude yq, saving(ellison1994,replace) ytitle("Estimated probability of collusion") ///
	xtitle("Quarter") xlabel(138(7)190)

log close
clear

log using panzer_rosse1987,replace
/******************** 16.7.4 Panzer-Rosse(1987) ********************/
insheet using bank_hi_pcm.csv, comma name
tsset year

/*take natural log of variables*/
generate ln_interest=log(tot_interest)
g ln_funding_rate=log(tot_funding_rate)
g ln_wage=log(wage)

reg ln_interest ln_funding_rate ln_wage 

estat dwatson
hettest

/* Wald test, H0: psi = 1 */
test ln_funding_rate + ln_wage = 1

/* Wald test, H0: psi <= 0 */
test ln_funding_rate + ln_wage = 0

log close

