use strict;
use warnings;

#スタブ、取引日（8桁）、スタブ、銘柄、取引時間（4桁）, 約定・気配フラグ
my $template = "A4 A8 A14 A4 A4 A2";
my %tradenum;

while(<>) {
    chomp;
    my ($date, $fut, $time, $yakujo) = (unpack $template, $_)[1,3,4,5];
#    print "$date,$time\n";

# 約定レコード以外ならスキップ
    next if($yakujo ne " 0");
# 日経平均先物以外ならスキップ
    next if($fut ne "0018");
# 分析期間のデータ以外ならスキップ
    next if(($date lt "20000101") || ($date gt "20001231"));
    next if(($date eq "20000104") or ($date eq  "20001229") or ($date eq "20000417"));
# 正規取引時間以外のデータはスキップ
    next if($time lt "0900");
    next if(($time gt "1100") &&  ($time lt "1230"));
    next if($time gt "1510");
# 取引回数を数える
    $tradenum{$date}{$time}++;
}

foreach my $d (sort keys %tradenum) {
    foreach my $t ("0900" .. "1510") {
	next if((unpack "A2A2", $t)[1] >= 60);
	next if(($t gt "1100") &&  ($t lt "1230"));
	if(!defined($tradenum{$d}{$t})) {
	    $tradenum{$d}{$t} = 0;
	}
# 取引日、取引時間、取引回数を表示
	print "$d,$t,$tradenum{$d}{$t}\n";
    }
}

