function Samples = mcmc_mfm(Stocks_Return,Factors_Return,Opts)
%**************************************************************************
% MATLAB/OctavepvOiMATLABłStatistics ToolboxKvj
% MuYETv[ɂ}`t@N^[Ef̃p[^
% eJW{̐
% c`mwoϊw@ȏƗY
%**************************************************************************
% T --- ֐
% N --- 
% K --- t@N^[
% 
% Stocks_Return  --- ʖ̎v (T x N)
% Factors_Return --- t@N^[ (T x K)
% Opts --- nCp[p[^Ȃǂ̐ݒ܂ލ\
% (1) Coef_Mean_Mean ---  AW̊Ғl̕ (K+1 x 1)
% (2) Coef_Mean_Var --- AW̊Ғl̕UUs (K+1 x K+1)
% (3) Coef_Var_Shape --- AW̕UUš`p[^
% (4) Coef_Var_Scale --- AW̕UUs̋K͍s (K+1 x K+1)
% (5) Error_Var_Shape --- 덷̕UUš`p[^
% (6) Error_Var_Scale --- 덷̕UUs̋K͍s (N x N)
% (7) Leverage --- Ȏ{䗦 (1 x N)
% (8) Burnin ---  ғԂ̉
% (9) Sample --- MuYETv[̌JԂ
% (10) Batch --- Tv̒oԊu
% o
% Samples --- eJW{̍\
% (1) MFM_Coef --- AW̃eJW{
%                  ŏK͋Ǝ핽ωAW
%                  ȍ~͑1ƁC2ƁCDDD̉AW
% (2) MFM_Var --- UUs̃eJW{
%                 ŏ(K+1)(K+2)/2͉AW̕W΍Ƒ֌W
%                 cN(N+1)/2͌덷̕W΍Ƒ֌W
%**************************************************************************
[T,N] = size(Stocks_Return); 
K = size(Factors_Return,2)+1; % K͉AW̐ (t@N^[ + 1)
KN = K*N;
vech_idx_K = reshape(tril(reshape((1:K*K),K,K)),1,K*K);
vech_idx_K = vech_idx_K(vech_idx_K>0);
vech_idx_N = reshape(tril(reshape((1:N*N),N,N)),1,N*N);
vech_idx_N = vech_idx_N(vech_idx_N>0);
IOmega_B = Opts.Coef_Mean_Var\eye(K);
IOmegaMu_B = IOmega_B*Opts.Coef_Mean_Mean;
Nu_E = Opts.Error_Var_Shape+T;
DF_E = .5*linspace(Nu_E,Nu_E-N+1,N);
Nu_B = Opts.Coef_Var_Shape+N;
DF_B = .5*linspace(Nu_B,Nu_B-K+1,K);
Scale_E = Opts.Error_Var_Scale;
Scale_B = Opts.Coef_Var_Scale;
Lev = [ones(1,N); repmat(Opts.Leverage,K-1,1)];
Y = Stocks_Return;
X = [ones(T,1) Factors_Return];
XX = X'*X;
XY = X'*Y;
B = X\Y;
bar_B = mean(B,2);
U = B-repmat(bar_B,1,N);
ISigma_B = (Nu_B-K-1)*((U*U'+Scale_B)\eye(K));
% MuYETv[
Sample_Size = Opts.Sample;
Burnin_Size = Opts.Burnin;
Batch_Size = Opts.Batch;
Iterations = Sample_Size+Burnin_Size;
MFM_Coef = zeros(floor(Sample_Size/Batch_Size),K+KN);
MFM_Var = zeros(floor(Sample_Size/Batch_Size),K*(K+1)/2+N*(N+1)/2);
jt = 1;
for it = 1:Iterations
    % 덷̕UUs$\Sigma_E$̐
    E = Y-X*B;
    S_E = Scale_E+E'*E;
    L_E = chol(S_E\eye(N))';
    A_E = tril(randn(N,N),-1)+diag(sqrt(2*randg(DF_E)));
    ISigma_E = L_E*(A_E*A_E')*L_E';
    % MATLABStatistics Toolboxł͊֐wishrnd()𗘗pł
    % ̏ꍇ70-72s폜ĉ̍sɒu
    %ISigma_E = wishrnd(S_E\eye(N),Nu_E);
    % AW$B$̐
    B_Var = (kron(ISigma_E,XX)+diag(reshape(Lev,KN,1)) ...
	     *kron(eye(N),ISigma_B)*diag(reshape(Lev,KN,1)))\eye(KN);
    B_Mean = B_Var*reshape((XY*ISigma_E+Lev.*repmat(ISigma_B*bar_B,1,N)),KN,1);
    b_v = B_Mean+chol(B_Var)'*randn(KN,1);
    B = reshape(b_v,K,N);
    LevB = Lev.*B;
    % AW$B$̕UUs$\Sigma_B$̐
    U = LevB-repmat(bar_B,1,N);
    S_B = Scale_B+U*U';
    L_B = chol(S_B\eye(K))';
    A_B = tril(randn(K,K),-1)+diag(sqrt(2*randg(DF_B)));
    ISigma_B = L_B*(A_B*A_B')*L_B';
    % MATLABStatistics Toolboxł͊֐wishrnd()𗘗pł
    % ̏ꍇ86-88s폜ĉ̍sɒu
    %ISigma_B = wishrnd(S_B\eye(K),Nu_B);
    % AW$B$̕$\bar B$̐
    bar_B_Var = (N*ISigma_B+IOmega_B)\eye(K);
    bar_B_Mean = bar_B_Var*(ISigma_B*sum(LevB,2)+IOmegaMu_B);
    bar_B = bar_B_Mean+chol(bar_B_Var)'*randn(K,1);
    % eJW{̕ۑ
    if it > Burnin_Size && mod(it,Batch_Size)==0
      MFM_Coef(jt,:) = [bar_B' reshape(B,1,KN)];
      Sigma_B = ISigma_B\eye(K);
      SD_B = sqrt(diag(Sigma_B));
      Corr_B = diag(1./SD_B)*Sigma_B*diag(1./SD_B);
      Cov_B = tril(Corr_B,-1)+diag(SD_B);
      vech_B = Cov_B(vech_idx_K);
      Sigma_E = ISigma_E\eye(N);
      SD_E = sqrt(diag(Sigma_E));
      Corr_E = diag(1./SD_E)*Sigma_E*diag(1./SD_E);
      Cov_E = tril(Corr_E,-1)+diag(SD_E);
      vech_E = Cov_E(vech_idx_N);
      MFM_Var(jt,:) = [vech_B vech_E];
      jt = jt+1;
    end
end
Samples.MFM_Coef = MFM_Coef;
Samples.MFM_Var = MFM_Var;
