# oCI}XEG^m[CO2팸ʕ
#
# oC}XEG^m[̓WCCO2Pʂ̌vZ
# 䕐mEFJ^muoCINCO2roƍ팸ʁ\K\ւ_CGbg܂Ł\v
# wOcww_Wx2009N3ɂ
# @ωF104\ւ̏Wvق
#
# YƘA֕\
# ȁu12NYƘA֕\v104\imj2004Nɂ
# http://www.stat.go.jp/data/io/index.htm
#
# CO2roW
# nZ^[
#u3EIDYƘA֕\ɂ׌Pʃf[^ubNv2006NɂB
# http://www-cger.nies.go.jp/publication/D031/jpn/page/data_file.htm
# 401\104֏WvCO2roWg
#
# f[^              [P]
# X,Fd,Ex,Im,VA,ct    [100~]         104YƘA֕\
# bio$co2_g[1:104]    [t-CO2/100~]   YPʓCO2roWiK\j
# bio$co2_ng[1:104]   [t-CO2/100~]   YPʓCO2roWiK\ȊOj
# bio$co2_ng[105]     [t-CO2/t-Ethanol] oCI}XEG^m[̐CO2roW
# bio$co2fd_g         [t-CO2/100~]   K\zK\RĎCO2roW
# bio$co2fd_ng[1:104] [t-CO2/100~]   K\ȊÕGlM[zCO2roW
# bio$co2fd_ng[105]   [t-CO2/t-Ethanol] oCI}XEG^m[gCO2roW
# bio$Xgas_j          [100~]         K\̘̔H\z
# bio$Ai_ethanol      [t-CO2/t-Ethanol] oCI}XEG^m[̓W
# bio$fd_g            [100~]         K\̍ŏIvxo
# bio$fd_ng[1:104]    [100~]         K\ȊO̔R̍ŏIvxo
# bio$fd_ng[105]      [t-Ethanol]       oCI}XEG^m[̏dʃg
#

# f[^̓ǂݍ
X<-read.table("X104.txt",header=TRUE,sep="\t")
Fd<-read.table("fd104.txt",header=TRUE,sep="\t")
Ex<-read.table("ex104.txt",header=TRUE,sep="\t")
Im<-read.table("im104.txt",header=TRUE,sep="\t")
VA<-read.table("v104.txt",header=TRUE,sep="\t")
ct<-read.table("ct104.txt",header=TRUE)
bio<-read.table("BioEtOH.txt",header=TRUE,sep="\t")

# vZpf[^̒`
n<-dim(X)[1]
I<-diag(1,nrow=n,ncol=n)
A<-array(data=0,dim=c(n,n))
cs<-array(data=0,dim=c(n))
gv<-array(data=0,dim=c(n))
iv<-array(data=0,dim=c(n))
ex<-array(data=0,dim=c(n))
x<-array(data=0,dim=c(n))
va<-array(data=0,dim=c(n))
v<-array(data=0,dim=c(n))

# ƌvOxo+ԏxo
cs<-Fd[,1]+Fd[,2]
# ʐ{ŏIxo+Œ莑{`(I)
gv<-Fd[,3]+Fd[,4]+Fd[,5]
# Œ莑{`()+݌ɏ
iv<-Fd[,6]+Fd[,7]
# Ao+
ex<-Ex[,1]+Ex[,2]
# A+֐+Ai: Af[^͂Ƃƃ}CiXœ͂ĂD
im<--(Im[,1]+Im[,2]+Im[,3])
# etlv
va<-VA[1,]+VA[2,]+VA[3,]+VA[4,]+VA[5,]+VA[6,]+VA[7,]
# Yz
x<-ct[,1]
# WšvZ
for( j in c(1:n)) {
  A[,j]<-X[,j]/x[j]
 }
#
# Simulationpf[^̒`
#
n_sim<-dim(bio)[1]
# Pʍs
Ident<-diag(1,nrow=n_sim,ncol=n_sim)
# xoŏIv CO2roȂŏIv({ɂ͉ΔRxo͂Ȃ)
f_nc<-vector(length=n_sim)
f_nc[1:n_sim]<-0
f_nc[1:n]<-gv+iv+ex-im
# K\iC΃K\EoCI}XR0.6CG^m[d 0.77
gas_price<-87.892 # 2000N Yen/Litre
i_gas<-29
i_etha<-105
gas_equiv<-1.0/0.6
etha_density<-0.77
# CO2roW ƍŏIv K\ƂȊO
co2g<-as.vector(bio$co2_g)
co2n<-as.vector(bio$co2_ng)
co2fg<-as.vector(bio$co2fd_g)
co2fn<-as.vector(bio$co2fd_ng)
fg<-as.vector(bio$fd_g)
fn<-as.vector(bio$fd_ng)
#
# Simulationp֐̒`
#
get_A_ethanol<-function(A,X,ct,bio,gas_price,gas_equiv,etha_density,i_gas,i_etha,r_subst){
  n_bio<-dim(bio)[1]
  n_A<-dim(A)[1]
  A105 <- matrix(data=0,nrow=n_bio,ncol=n_bio)
  A105[1:n_A,1:n_A] <- A
  A105[1:n_A,i_etha] <- bio$Ai_ethanol[1:n_A]
  Xg<-as.vector(bio$Xgas_j)
  gas_x_litre<-Xg/gas_price # million litre
  etha_x_litre<-gas_x_litre*gas_equiv*r_subst
  for(j in 1:n_A){
    A105[i_gas,j]<-(X[i_gas,j]- Xg[j]*r_subst)/ct[j]
    A105[i_etha,j] <- etha_x_litre[j]*etha_density*1000.0/ct[j]
  }
  A105[i_etha,i_etha] <- 0
  return(A105)
}
get_fd_ethanol<-function(fg,fn,gas_price,gas_equiv,etha_density,i_gas,i_etha,r_subst){
  fd105<-fn
  fd105[i_gas]<-fd105[i_gas]+fg[i_gas]*(1-r_subst)
  gas_fd_litre<-(fg[i_gas]*r_subst)/gas_price # million litre
  etha_fd_litre<-gas_fd_litre*gas_equiv
  fd105[i_etha]<-etha_fd_litre*etha_density*1000.0 # tonne
  return(fd105)
}
#
# Simulation 00 : ethanol substitution (֗) 0%
#
r_subst<-0.0
As00<-get_A_ethanol(A,X,x,bio,gas_price,gas_equiv,etha_density,i_gas,i_etha,r_subst)
fs00<-get_fd_ethanol(fg,fn,gas_price,gas_equiv,etha_density,i_gas,i_etha,r_subst)
Bs00<-solve(Ident - As00)
xs00<-Bs00%*%(f_nc+fs00)
CO2cn_00<-(co2n+co2g*(1-r_subst))*xs00
co2fd_s00<-co2fn*fn+co2fg*fg*(1-r_subst)
sum(CO2cn_00)+sum(co2fd_s00)
#
# Simulation 10 : ethanol substitution (֗) 100%
#
r_subst<-1.00
As10<-get_A_ethanol(A,X,x,bio,gas_price,gas_equiv,etha_density,i_gas,i_etha,r_subst)
fs10<-get_fd_ethanol(fg,fn,gas_price,gas_equiv,etha_density,i_gas,i_etha,r_subst)
Bs10<-solve(Ident - As10)
xs10<-Bs00%*%(f_nc+fs10)
CO2cn_10<-(co2n+co2g*(1-r_subst))*xs10
co2fd_s10<-co2fg*fg*(1-r_subst)+co2fn*fn
sum(CO2cn_10)+sum(co2fd_s10)
#
# Simulation : ethanol substitution (֗) 0-100%
#
j<-1
biz_cn<-numeric(101) # Carbon neutral
hhd_cn<-numeric(101) # Carbon neutral
biz_nn<-numeric(101) # adding CO2 from bioethanol
hhd_nn<-numeric(101) # adding CO2 from bioethanol
for( i in seq(1,101,by=5)){
  r_subst<-(i-1.0)/100.0
  As<-get_A_ethanol(A,X,x,bio,gas_price,gas_equiv,etha_density,i_gas,i_etha,r_subst)
  fs<-get_fd_ethanol(fg,fn,gas_price,gas_equiv,etha_density,i_gas,i_etha,r_subst)
  Bs<-solve(Ident - As)
  xs<-Bs%*%(f_nc+fs)
  biz_cn[j]<-sum((co2n+co2g*(1-r_subst))*xs)
  hhd_cn[j]<-sum(co2fn*fn+co2fg*fg*(1-r_subst))
  biz_nn[j]<-biz_cn[j]+co2fn[i_etha]*(xs[i_etha]-fs[i_etha])
  hhd_nn[j]<-hhd_cn[j]+sum(co2fn[i_etha]*fs[i_etha])
  j<-j+1
}
#
# Ot\p̑
#
length(biz_cn)<-j-1
length(hhd_cn)<-j-1
length(biz_nn)<-j-1
length(hhd_nn)<-j-1

dev.off()
xlbl<-seq(0,101,by=5)
y_max<-max(biz_cn+hhd_cn)
plot(biz_cn,xlab="֗ (%)",ylab="CO2ro (St-CO2)",axes=0,type="l",ylim=c(1100*10^6,y_max))
lines(biz_cn+hhd_cn)
axis(1, 1:21,labels = formatC(xlbl, format="fg"))
(my.at<-seq(10^9*0.95,10^9*1.36,,by=10^7*5))
axis(2, my.at,labels = formatC(my.at/10^6, format="fg"))
text(15,1120*10^6,"(Yƕ)")
text(5,1200*10^6,"(ƌv)")
text(15,1300*10^6,"ro")
cbind(biz_cn,hhd_cn,biz_cn+hhd_cn)

dev.new() # ʂWindowsɕ\ꍇ
y_max<-max(biz_nn+hhd_nn)
plot(biz_nn,xlab="֗ (%)",ylab="CO2ro (St-CO2)",axes=0,type="l",ylim=c(1100*10^6,y_max),main="oCI}XEG^m[CO2ꍇ")
lines(biz_nn+hhd_nn)
lines(biz_cn,col="Red")
lines(biz_cn+hhd_cn,col="Red")
axis(1, 1:21,labels = formatC(xlbl, format="fg"))
(my.at<-seq(10^9*0.95,10^9*1.46,,by=10^7*5))
axis(2, my.at,labels = formatC(my.at/10^6, format="fg"))
text(15,1120*10^6,"(Yƕ)")
text(5,1250*10^6,"(ƌv)")
text(15,1325*10^6,"ro")
